#ifndef NASCCL_MMutate_Cpp
#define NASCCL_MMutate_Cpp
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/*
    MatrixMutate is used to mutate the entire matrix every full round.

    This function is called only from the Encode / Decode functions
    and only when the FMATRIXMUTATION, RMATRIXMUTATION and or CMATRIXMUTATION flag is set.

    An excellent encryption perk. Super slow... Six loops per full round
*/
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "NASCCL.H"
#include "sBoxes.H"
#include "Math.H"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void NASCCL::MatrixMutate(NASCCLByte inMutateVal)
{
    int MMutate = 0;
    while(MMutate != 6)
    {
        Matrix[MMutate][0] = (Matrix[MMutate][0] + inMutateVal);
        Matrix[MMutate][1] = (Matrix[MMutate][1] + inMutateVal);
        Matrix[MMutate][2] = (Matrix[MMutate][2] + inMutateVal);
        Matrix[MMutate][3] = (Matrix[MMutate][3] + inMutateVal);
        Matrix[MMutate][4] = (Matrix[MMutate][4] + inMutateVal);
        Matrix[MMutate][5] = (Matrix[MMutate][5] + inMutateVal);
        MMutate++;
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
#endif

